/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.smeltery.block.entity.controller.MelterBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiTankModule;
import slimeknights.tconstruct.smeltery.menu.MelterContainerMenu;

public class MelterScreen
extends class_465<MelterContainerMenu>
implements IScreenWithFluidTank {
    private static final class_2960 BACKGROUND = TConstruct.getResource("textures/gui/melter.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 0, 52, 52, 256, 256);
    private static final ElementScreen FUEL_SLOT = new ElementScreen(176, 52, 18, 36, 256, 256);
    private static final ElementScreen FUEL_TANK = new ElementScreen(194, 52, 14, 38, 256, 256);
    private final GuiMeltingModule melting;
    private final GuiFuelModule fuel;
    private final GuiTankModule tank;

    public MelterScreen(MelterContainerMenu container, class_1661 inv, class_2561 name) {
        super((class_1703)container, inv, name);
        MelterBlockEntity te = (MelterBlockEntity)container.getTile();
        if (te != null) {
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule(this, te.getMeltingInventory(), fuelModule::getTemperature, slot -> true);
            this.fuel = new GuiFuelModule(this, fuelModule, 153, 32, 12, 36, 152, 15, container.isHasFuelSlot());
            this.tank = new GuiTankModule(this, (StorageView<FluidVariant>)te.getTank(), 90, 16, 52, 52, MelterContainerMenu.TOOLTIP_FORMAT);
        } else {
            this.melting = null;
            this.fuel = null;
            this.tank = null;
        }
    }

    public void method_25394(class_332 graphics, int x, int y, float partialTicks) {
        this.method_25420(graphics);
        super.method_25394(graphics, x, y, partialTicks);
        this.method_2380(graphics, x, y);
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.fuel != null) {
            if (((MelterContainerMenu)this.field_2797).isHasFuelSlot()) {
                FUEL_SLOT.draw(graphics, BACKGROUND, this.field_2776 + 150, this.field_2800 + 31);
            } else {
                FUEL_TANK.draw(graphics, BACKGROUND, this.field_2776 + 152, this.field_2800 + 31);
            }
            this.fuel.draw(graphics, BACKGROUND);
        }
        if (this.tank != null) {
            this.tank.draw(graphics);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        int checkX = mouseX - this.field_2776;
        int checkY = mouseY - this.field_2800;
        if (this.tank != null) {
            this.tank.highlightHoveredFluid(graphics, checkX, checkY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, checkX, checkY);
        }
        RenderUtils.setup(BACKGROUND);
        SCALA.draw(graphics, BACKGROUND, 90, 16);
        if (this.melting != null) {
            this.melting.drawHeatBars(graphics, BACKGROUND);
        }
    }

    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        super.method_2380(graphics, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderTooltip(graphics, mouseX, mouseY);
        }
        if (this.melting != null) {
            this.melting.drawHeatTooltips(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.addTooltip(graphics, mouseX, mouseY, true);
        }
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.field_2776;
        int checkY = (int)mouseY - this.field_2800;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.tank != null && ingredient == null) {
            ingredient = this.tank.getIngreientUnderMouse(checkX, checkY);
        }
        return ingredient;
    }
}

